package com.junmp.junmpProcess.service.Bussiness;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.junmp.junmpProcess.common.Result;
import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.dto.*;
import com.junmp.junmpProcess.entity.ProcessTemplates;
import com.junmp.junmpProcess.vo.*;
import com.junmp.jyzb.api.bean.query.ProcessReq.FormReq;
import com.junmp.jyzb.api.bean.query.ProcessReq.SuspendOrActivateDefinitionReq;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

public interface WorkProcessService {


    /**
     * 创建表单
     *
     * @return
     */
    Boolean createNewForm(FormReq processVO) ;

    /**
     * 终止流程实例
     *
     * @return
     */
    ApiRes<Boolean> stopProcessInstanceById(HandleDataDTO handleDataDTO) ;

    /**
     * 挂起流程定义
     *
     * @return
     */
    Boolean suspendOrActivateProcessDefinitionById(SuspendOrActivateDefinitionReq req) ;
    /**
     * 创建表单
     *
     * @return
     */
    Boolean createBpmn(ProcessVO processVO) throws JsonProcessingException;
    /**
     * 编辑表单
     *
     * @return
     */
    Boolean deleteProcessInstance(ProcessDTO processInstance);

    /**
     * 编辑表单
     *
     * @return
     */
    Boolean updateForm(UpdateProcessVO process)throws JsonProcessingException;
    /**
     * 编辑表单名称
     *
     * @return
     */
    Boolean updateFormName(UpdateProcessVO process);

    Boolean turn(TurnVo turns);

    /**
    * @Author: Zhaojw
    * @Description:
    * @DateTime: 2023/6/26 13:05
    * @Params:
    * @Return
    */
    ResponseResult getFormDetail(String templateId);

    /**
     * 获取用户可见表单
     *
     * @return
     */
    PageResult<TemplateGroupVo>  getFormList(BaseRequest br);


    /**
     * 通过模板id查看流程信息 会附带流程定义id
     *
     * @return
     */
    Result<ProcessTemplates> detail(String templateId);

    /**
     * 通过流程定义id启动流程
     *
     * @return
     */
    String start(StartProcessInstanceDTO startProcessInstanceDTO);

    /**
     * 通过流程定义id启动流程
     *
     * @return
     */
    ApiRes<List<TaskDetailVO>> record(String processInstanceId);


    /**
     * 查看我发起的流程
     *
     * @return
     */
    PageResult<HistoryProcessInstanceVO> applyList(ApplyDTO applyDTO);

    /**
     * 查看我的待办
     *
     * @return
     */
    PageResult<TaskVO> toDoList(TaskDTO taskDTO);

    /**
     * 查看我的已办
     *
     * @return
     */
    PageResult<TaskVO> doneList(@RequestBody TaskDTO taskDTO);

    /**
     * 同意
     *
     * @return
     */
    ResponseResult agree(HandleDataDTO handleDataDTO);

    /**
     * 同意
     *
     * @return
     */
    ResponseResult revoke(HandleDataDTO handleDataDTO);
    /**
     * 委派
     *
     * @return
     */
    Result delegateTask(HandleDataDTO handleDataDTO);

    /**
     * 委派人完成的按钮
     *
     * @return
     */
    Result resolveTask(@RequestBody HandleDataDTO handleDataDTO);

    /**
     * 拒绝
     *
     * @return
     */
    ResponseResult refuse(HandleDataDTO handleDataDTO);



    /**
     * 转办按钮
     *
     * @return
     */
    Result assignee(HandleDataDTO handleDataDTO);

    /**
     * 退回按钮
     *
     * @return
     */
    Result rollback(HandleDataDTO handleDataDTO);

    /**
     * 加签按钮
     *
     * @return
     */
    Result addMulti(HandleDataDTO handleDataDTO);

    /**
     * 查到签上的人
     *
     * @return
     */
    Result<List<MultiVO>> queryMultiUsersInfo(Map<String, Object> map);

    /**
     * 减签按钮
     *
     * @return
     */
    Result deleteMulti(List<String> executionIds);

    /**
     * 评论按钮
     *
     * @return
     */
    Result comments(HandleDataDTO handleDataDTO);

    /**
     * 通过流程实例id查看详情
     *
     * @return
     */
    ApiRes<HandleDataVO> instanceInfo(HandleDataDTO HandleDataDTO);

    /**
     * 通过流程实例id查看详情
     *
     * @return
     */
    ApiRes<String> getProcessDefinitionId(String formId);
//    /**
//     * 上传文件
//     * @return
//     */
//    Result<AttachmentVO> upLoadFile(MultipartFile file, HttpServletRequest request);
//    /**
//     * 下载文件
//     * @return
//     */
//    void downLoadFile( String name);
}
