package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum TriggerExceptionEnum implements IExceptionEnum {
    /**
     *
     */
    TRIGGER_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "触发器不存在"),
    /**
     *
     */
    TRIGGER_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"触发器已存在");



    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    TriggerExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
