package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName bussiness_order_log
 */
@TableName(value ="bussiness_order_log")
@Data
public class OrderLog implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 单据类型（in入库单，out出库单）
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 单据业务类型
     */
    @TableField(value = "bussiness_type")
    private String bussinessType;

    /**
     * 单据id（对应order_main）
     */
    @TableField(value = "order_id")
    private String orderId;

    /**
     * 操作记录（upload上传消息）
     */
    @TableField(value = "history_msg")
    private String historyMsg;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 单据单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 应入/出库数量
     */
    @TableField(value = "inventory_quantity",updateStrategy = FieldStrategy.IGNORED)
    private Integer inventoryQuantity;

    /**
     * 实际数量
     */
    @TableField(value = "actual_quantity",updateStrategy = FieldStrategy.IGNORED)
    private Integer actualQuantity;

    /**
     * 修改后数量
     */
    @TableField(value = "update_quantity")
    private Integer updateQuantity;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user",updateStrategy = FieldStrategy.IGNORED)
    private String createUser;

    /**
     * 修改人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 过程事件（创建单据createOrder,出入库OutAndIn，记账accounting）
     */
    @TableField(value = "process_type")
    private String processType;

    private static final long serialVersionUID = 1L;

}