﻿using AutoMapper;
using Common.Utility.Model;
using Models.SqlModel;
using Models.Table;
using Models.ToolsModel;
using Repositories.IRepository.IBussiness;
using Services.Interface;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class LogService : BaseService<LogSummary>, ILogService
    {
        private readonly ILogSummaryRepository _logSummaryRepository;
        private readonly ILogDetailRepository _logDetailRepository;
        public IMapper mapper;

        public LogService(ILogSummaryRepository logSummaryRepository, ILogDetailRepository logDetailepository, IMapper _mapper)
        {
            base.BaseDal = logSummaryRepository;
            _logSummaryRepository = logSummaryRepository;
            _logDetailRepository = logDetailepository;
            mapper = _mapper;
        }

        public Task<bool> AddLogs(RecordsReq model)
        {

            LogSummary log = mapper.Map<LogSummary>(model);
            log.updateTime = DateTime.Now;
            log.createTime = DateTime.Now;
            if (model.equipmentList!=null)
            {
                foreach (var item in model.equipmentList)
                {
                    LogDetail logdetail = mapper.Map<LogDetail>(item);
                    logdetail.createTime = DateTime.Now;
                    logdetail.updateTime = DateTime.Now;
                    logdetail.state = item.outInState;
                    log.DetailList.Add(logdetail);
                }
            }
            if (model.carList != null)
            {
                foreach (var item in model.carList)
                {
                    LogDetail logdetail = new LogDetail();
                    logdetail.createTime = DateTime.Now;
                    logdetail.updateTime = DateTime.Now;
                    logdetail.equipmentName = item.carName;
                    logdetail.equipmentSize = item.carNumber;
                    logdetail.state = item.outInState;
                    log.DetailList.Add(logdetail);
                }
            }
                
            List<Inventory> inveqList = model.equipmentList?.Select(x => new Inventory()
            {
                updateTime = DateTime.Now,
                epc=x.epc,
                state = x.outInState.ToString()
            }).ToList();
            List<Car> invCarList = model.carList?.Select(x => new Car()
            {
                updateTime=DateTime.Now,
                id=x.carId,
                state = x.outInState.ToString()
            }).ToList();
            return _logSummaryRepository.AddLogs(log, inveqList, invCarList);
        }
    }
}
