﻿using Repositories.IRepository.IUnitOfWork;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.UnitOfWork
{
    public sealed class LocalSugarUnitOfWork : ILocalSugarUnitOfWork
    {
        private ISqlSugarClient _sqlSugarClient;

        public LocalSugarUnitOfWork(ISqlSugarClient sqlSugarClient)
        {
            _sqlSugarClient = sqlSugarClient;
        }


        public SqlSugarClient GetDbClient()
        {
            // 必须要as，后边会用到切换数据库操作
            return _sqlSugarClient as SqlSugarClient;
        }

        public void BeginTran()
        {
            GetDbClient().BeginTran();
        }

        public void CommitTran()
        {
            try
            {
                GetDbClient().CommitTran();
            }
            catch (Exception ex)
            {
                GetDbClient().RollbackTran();
                throw ex;
            }
        }

        public void RollbackTran()
        {
            GetDbClient().RollbackTran();
        }

        public void Dispose()
        {
            GC.SuppressFinalize(this);
        }
        ~LocalSugarUnitOfWork()
        {
            Dispose();
        }
    }
}
