﻿using AutoMapper;
using Models.SqlModel;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class LogSummaryRepository : BaseRepository<LogSummary>, ILogSummaryRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public LogSummaryRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<bool> AddLogs(LogSummary model, List<Inventory> inv, List<Car> cars)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    //var invs = await context.Queryable<Inventory>().Where(x =>
                    //model.DetailList.Select(x => x.epc).Contains(x.epc)).ToListAsync();
                    context.BeginTran();
                     context.Updateable(cars).WhereColumns(it => new { it.id }).UpdateColumns(it => new { it.state, it.updateTime }).ExecuteCommand();//实体有多少列更新多少列
                    
                    var result =  context.Updateable(inv).WhereColumns(it=>new { it.epc }).UpdateColumns(it => new { it.state,it.updateTime}).ExecuteCommand();//实体有多少列更新多少列
                    var logSum =  context.InsertNav(model)
                        .Include(z1=>z1.DetailList)
                        .ExecuteCommandAsync();
                    context.CommitTran();
                }
                catch (Exception e)
                {
                    throw e;
                }
            }
            return true;
        }
    }
}
