﻿using Models.ToolsModel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.IRepository
{
    public interface IBaseRepository<TEntity> where TEntity : class
    {
        Task<int> Add(TEntity entity);
        Task<int> Add(List<TEntity> listEntity);
        Task<bool> Update(TEntity entity);
        int UpdateObjs(List<TEntity> entity);
        Task<bool> DeleteByIds(int[] ids);
        Task<bool> DeleteById(object id);

        Task<TEntity> QueryOne(Expression<Func<TEntity, bool>> whereExpress);
        Task<TEntity> QueryOneOrderDesc(Expression<Func<TEntity, bool>> whereExpresson, Expression<Func<TEntity, object>> orderExpression);
        Task<TEntity> QueryOneOrder(Expression<Func<TEntity, bool>> whereExpresson, Expression<Func<TEntity, object>> orderExpression);

        Task<List<TEntity>> Query();
        Task<List<TEntity>> Query(Expression<Func<TEntity, bool>> whereExpression);
        Task<PageModel<TEntity>> QueryPage(Expression<Func<TEntity, bool>> whereExpression, int intPageIndex = 1, int intPageSize = 20, string strOrderByFileds = null);
        Task<PageModel<TResult>> QueryMuch<T, T2, T3, TResult>(
           int intPageIndex,
           int intPageSize,
           string strOrderByFileds,
           string where,
           Expression<Func<T, T2, T3, object[]>> joinExpression,
           Expression<Func<T, T2, T3, TResult>> selectExpression
           ) where T : class, new();
    }
}
