﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Models.ToolsModel
{
    /// <summary>
    /// 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class BaseResponse<T>
    {
        public static BaseResponse<T> GetResponse(T t, StatusCode code, string msg)
        {
            return new BaseResponse<T>() { code = code, msg = msg, data = t == null ? default(T) : t };
        }

        public string msg { get; set; }

        public StatusCode code { get; set; }


        public T data { get; set; }
    }


    public enum StatusCode
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success = 1,

        /// <summary>
        /// 失败
        /// </summary>
        Fail = 2,

        /// <summary>
        /// 参数为空
        /// </summary>
        ParamsNull = 3,

        /// <summary>
        /// 
        /// </summary>
        NoAccess = 4,

        /// <summary>
        /// Token失效
        /// </summary>
        ErrorToken = 5,

        /// <summary>
        /// 没有权限
        /// </summary>
        ErrorAuth = 6,
    }
}
