﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Principal;
using System.Text;
using System.Threading.Tasks;

namespace Models.Table
{

    [SugarTable("base_log_summary")]
    public class LogSummary : BaseTable
    {
        [SugarColumn(IsIdentity = true, IsPrimaryKey = true)]

        public int id { get; set; }
        [SugarColumn(ColumnName = "cabinet_id")]
        public String cabinet_id { get; set; }
    
        public int type { get; set; }
        [SugarColumn(ColumnName = "user_name")]
        public String? user_name { get; set; }

        public String? equipments { get; set; }
        [SugarColumn(ColumnName = "use_time")]
        public DateTime? useTime { get; set; }
        [SugarColumn(ColumnName = "plan_id")]
        public String? planId { get; set; }
        [SugarColumn(ColumnName = "plan_name")]
        public String? planName { get; set; }



        [Navigate(NavigateType.OneToMany, nameof(LogDetail.summaryId))]
        public List<LogDetail> DetailList { get; set; } = new List<LogDetail>();
    }
}
