﻿using RabbitMQ.Client.Events;
using RabbitMQ.Client;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Extensions.Hosting;
using Common.Global;
using Newtonsoft.Json;
using Common.Utility.Model;
using Services.Interface;
using Services;

namespace Common.Utility.RabbitMQ
{

    public class RabbitMQCustomContext : BackgroundService
    {
        ConnectionFactory factory = null;
        IConnection connection = null;
        private readonly ILogService _LogService;

        public RabbitMQCustomContext(ILogService logService)
        {
            _LogService = logService;
        }


        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            try
            {


                //创建连接对象工厂
                factory = new ConnectionFactory()
                {
                    UserName = AdminGlobalContext.RabbitMQConfig.UserName,
                    Password = AdminGlobalContext.RabbitMQConfig.Password,
                    HostName = AdminGlobalContext.RabbitMQConfig.HostName,
                    Port = AdminGlobalContext.RabbitMQConfig.Port,
                    RequestedHeartbeat = TimeSpan.FromSeconds(30), //心跳包
                    AutomaticRecoveryEnabled = true, //自动重连
                    TopologyRecoveryEnabled = true, //拓普重连
                    NetworkRecoveryInterval = TimeSpan.FromSeconds(10)
                };
                //创建连接对象
                connection = factory.CreateConnection();

                IModel channel = connection.CreateModel();
                channel.ExchangeDeclare(AdminGlobalContext.RabbitMQConfig.ExchangeName, ExchangeType.Fanout);
                channel.QueueDeclare(AdminGlobalContext.RabbitMQConfig.QueueName, false, false, false, null);
                channel.QueueBind(AdminGlobalContext.RabbitMQConfig.QueueName, AdminGlobalContext.RabbitMQConfig.ExchangeName, "", null);
                var consumer = new EventingBasicConsumer(channel);
                consumer.Received += (ch, ea) =>
                {
                    var body = ea.Body.ToArray();
                    string str = Encoding.UTF8.GetString(body);
                    RecordsReq req = JsonConvert.DeserializeObject<RecordsReq>(str);
                    Console.WriteLine("接受到的mq消息：" + str);
                    _LogService.AddLogs(req);
                    channel.BasicAck(ea.DeliveryTag, false);
                    //Thread.Sleep(1000);
                };
                string consumerTag = channel.BasicConsume(AdminGlobalContext.RabbitMQConfig.QueueName, false, consumer);

            }
            catch (Exception)
            {

                throw;
            }
        }


    }
}
