﻿using APIs.Profiles;
using Autofac;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.IdentityModel.Tokens;
using Microsoft.OpenApi.Models;
using Repositories.IRepository.IBussiness;
using Repositories.Repository.Bussiness;
using Services.Interface;
using Services;
using System.Configuration;
using System.Reflection;
using System.Text;
using APIs.Extensions;
using FluentValidation.AspNetCore;
using Repositories.IRepository.IUnitOfWork;
using Repositories.Repository.UnitOfWork;
using Common.Utility.RabbitMQ;
using Common.Global;
using System.Xml.Linq;

namespace APIs
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }
        public IConfiguration Configuration { get; }
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddSqlsugarSetup(Configuration);


            services.AddMemoryCache();
            //services.AddControllers(o =>
            //{
            //    o.AllowEmptyInputInBodyModelBinding = true;
            //});
            services.AddControllers()
                .AddNewtonsoftJson(options =>
                {
                   
                    options.SerializerSettings.ReferenceLoopHandling = Newtonsoft.Json.ReferenceLoopHandling.Ignore;
                    options.SerializerSettings.DateFormatString = "yyyy-MM-dd HH:mm:ss";
                });
            // Learn more about configuring Swagger/OpenAPI at https://aka.ms/aspnetcore/swashbuckle
            services.AddEndpointsApiExplorer();
            services.AddAutoMapper(typeof(MapperProfile));
            services.AddSwaggerGen(options =>
            {
            
            });
            #region Service
            services.AddScoped<ILocalSugarUnitOfWork, LocalSugarUnitOfWork>();
            services.AddScoped<IPoliceService, PoliceService>();
            services.AddScoped<ICarService, CarService>();
            services.AddScoped<IEquipmentSizeService, EquipmentSizeService>();
            services.AddScoped<IEquipmentTypeService, EquipmentTypeService>();
            services.AddScoped<ILogService, LogService>();
            #endregion

            #region Repository
            services.AddScoped<IPoliceRepository, PoliceRepository>();
            services.AddScoped<ICarRepository, CarRepository>();
            services.AddScoped<IEquipmentSizeRepository, EquipmentSizeRepository>();
            services.AddScoped<IEquipmentTypeRepository, EquipmentTypeRepository>();
            services.AddScoped<ILogDetailRepository, LogDetailRepository>();
            services.AddScoped<ILogSummaryRepository, LogSummaryRepository>();
            #endregion

            #region 注册RabbitMQ消费者
            services.AddHostedService<RabbitMQCustomContext>();

            #endregion

            #region 初始化全局配置信息


            InitConfiguration(Configuration);
            #endregion
            services.AddFluentValidation(options =>
            {
                options.RegisterValidatorsFromAssembly(Assembly.GetExecutingAssembly());
            });
            services.AddCors(options =>
            {
                options.AddPolicy("Cors", policy =>
                {
                    policy
                        .AllowAnyOrigin()
                        .AllowAnyHeader()
                        .AllowAnyMethod();
                });
            });

        }

        public void ConfigureContainer(ContainerBuilder builder)
        {
            var basePath = AppContext.BaseDirectory;

        
        }
        #region 初始化全局静态配置

        /// <summary>
        /// 初始化全局静态配置
        /// </summary>
        private void InitConfiguration(IConfiguration configuration)
        {
            RabbitMQConfig rabbits = new RabbitMQConfig();
            rabbits.Port = int.Parse(configuration.GetSection("RabbitMQConfig:Port").Value);
            rabbits.QueueName = configuration.GetSection("RabbitMQConfig:QueueName").Value;
            rabbits.HostName = configuration.GetSection("RabbitMQConfig:HostName").Value;
            rabbits.ExchangeName = configuration.GetSection("RabbitMQConfig:ExchangeName").Value;
            rabbits.UserName = configuration.GetSection("RabbitMQConfig:UserName").Value;
            rabbits.Password = configuration.GetSection("RabbitMQConfig:Password").Value;
            AdminGlobalContext.RabbitMQConfig = rabbits;

        }

        #endregion
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseSwagger();

            app.UseSwaggerUI(c =>
            {
                c.SwaggerEndpoint("/swagger/v1/swagger.json", "api.core");
            });

            app.UseCors("Cors");

            app.UseHttpsRedirection();

            app.UseStaticFiles();

            app.UseRouting();

            //先开启认证
            app.UseAuthentication();

            //然后是授权中间件
            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }

    }
}
