using System.Configuration;
using System.Reflection;
using System.Reflection.Metadata;
using System.Text;
using System.Xml.Linq;
using APIs;
using APIs.Extensions;
using APIs.Profiles;
using Autofac.Core;
using Autofac.Extensions.DependencyInjection;
using Common;
using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.Extensions.Configuration;
using Microsoft.IdentityModel.Tokens;
using Microsoft.OpenApi.Models;
using NLog.Web;
using Repositories;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using Repositories.Repository.Bussiness;
using Repositories.Repository.UnitOfWork;
using Services;
using Services.Interface;




public class Program
{
    public static void Main(string[] args)
    {
        var logger = NLogBuilder.ConfigureNLog("nlog.config").GetCurrentClassLogger();
        try
        {
            Console.WriteLine($"[{DateTime.Now.ToString("yyyy-MM-dd HH:mm")}]"+ "--------------ʼ--------------");
            Console.WriteLine("ɹ");
            CreateHostBuilder(args).Build().Run();

        }
        catch (Exception exception)
        {
            logger.Error(exception, "--------------Stopped program because of exception--------------");
            Console.WriteLine(""+exception);
            throw;
        }
        finally
        {
            NLog.LogManager.Shutdown();
        }
    }




    public static IHostBuilder CreateHostBuilder(string[] args)
    {
        var configuration = new ConfigurationBuilder()
       .SetBasePath(Directory.GetCurrentDirectory())
       .AddJsonFile("appsettings.json", optional: false)
       .Build();

        return Host.CreateDefaultBuilder(args)
        .UseServiceProviderFactory(new AutofacServiceProviderFactory())
        .ConfigureWebHostDefaults(webBuilder =>
        {
            webBuilder.UseStartup<Startup>();
            webBuilder.UseUrls(configuration["Launch"]);

        })

    .ConfigureLogging(logging =>
    {
        logging.ClearProviders();
        logging.SetMinimumLevel(LogLevel.Trace);
    })
    .UseNLog();
    }
}