﻿using APIs.Common;
using APIs.Dto;
using APIs.Req;
using Autofac.Core;
using AutoMapper;
using Common.Utility.Model;
using Common.Utility.RabbitMQ;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using Models.SqlModel;
using Models.ToolsModel;
using Newtonsoft.Json;
using Services;
using Services.Interface;
using SqlSugar;
using static Microsoft.AspNetCore.Razor.Language.TagHelperMetadata;

namespace APIs.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class BaseInfoController : ControllerBase
    {
        public IMapper Mapper { get; }
        private readonly IPoliceService _policeService;
        private readonly IEquipmentTypeService _equipmentTypeService;
        private readonly IEquipmentSizeService _equipmentSizeService;
        private readonly ICarService _carService;
        public BaseInfoController(IMapper mapper,IPoliceService policeService, IEquipmentTypeService equipmentTypeService,
            IEquipmentSizeService equipmentSizeService,ICarService carService)
        {
            _carService = carService;
            _equipmentSizeService = equipmentSizeService;
            _equipmentTypeService = equipmentTypeService;
            _policeService = policeService;
            Mapper = mapper;
        }

        /// <summary>
        /// 新增基础信息
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public virtual async Task<ApiResult> UploadInfo([FromBody] InfoListReq req)
        {

            try
            {
                string idlist = string.Join(",", req.infoList.Select(d => d.policeId).ToArray());
                var list = idlist.Split(",");
                var police = await _policeService.Query(p => list.Contains(p.id));
                if (police != null)
                {
                    foreach (var item in police)
                    {
                        var itemnew = req.infoList.Where(p => p.policeId.Equals(item.id)).FirstOrDefault();
                        if (itemnew != null)
                        {
                            item.fingerInfo = itemnew.fingerInfo;
                            item.faceInfo = itemnew.faceInfo;
                        }
                        
                    }
               
                    int result=  _policeService.UpdateObjs(police);
                    if (result > 0)
                    {
                        var src = new ApiResult
                        {
                            code = ResultCode.OPERATE_SUCCESS.Code,
                            msg = ResultCode.OPERATE_SUCCESS.Msg,
                            data = police
                        };
                        return src;
                    }
                    else {
                        var src = new ApiResult
                        {
                            code = ResultCode.POLICE_ERROR.Code,
                            msg = ResultCode.POLICE_ERROR.Msg,
                            data = ""
                        };
                        return src;
                    }
                  
                }
                else
                {
                    var src = new ApiResult
                    {
                        code = ResultCode.POLICE_ERROR.Code,
                        msg = ResultCode.POLICE_ERROR.Msg,
                        data = ""
                    };
                    return src;
                }
                
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,

                };
                return error;
            }

        }

        /// <summary>
        /// 查询人员信息
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public virtual async Task<ApiResult> GetAllPersonnel([FromBody] CommonReq req)
        {

            try
            {
                DateTime reqTime = DateTime.MinValue;
                if (!string.IsNullOrEmpty(req.updateTime))
                {
                    reqTime = DateTime.Parse(req.updateTime);
                }
                var police = await _policeService.Query(p=>p.updateTime>= reqTime);
                var src = new ApiResult
                {
                    code = ResultCode.OPERATE_SUCCESS.Code,
                    msg = ResultCode.OPERATE_SUCCESS.Msg,
                    data = police
                };
                return src;
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,

                };
                return error;
            }

        }

        /// <summary>
        /// 查询装备类型信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]

        public  async Task<string> GetEquipmentType([FromBody] CommonReq req)
        {

            try
            {
                DateTime reqTime = DateTime.MinValue;
                if (!string.IsNullOrEmpty(req.updateTime))
                {
                    reqTime = DateTime.Parse(req.updateTime);
                }
                var typeQuery = await _equipmentTypeService.Query(p => p.updateTime >= reqTime);
                List<EquipmentTypeDto> typeDto = new List<EquipmentTypeDto>() ;
                Mapper.Map(typeQuery, typeDto);
                var src = new ApiResult
                {
                    code = ResultCode.OPERATE_SUCCESS.Code,
                    msg = ResultCode.OPERATE_SUCCESS.Msg,
                    data= typeDto
                };
                return JsonConvert.SerializeObject(src);
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,
                  
                };
                return JsonConvert.SerializeObject(error);
            }

        }

        /// <summary>
        /// 查询装备号型信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]

        public async Task<string> GetEquipmentSize([FromBody] CommonReq req)
        {

            try
            {
                DateTime reqTime= DateTime.MinValue;
                if (!string.IsNullOrEmpty(req.updateTime))
                {
                    reqTime = DateTime.Parse(req.updateTime);
                }
                var sizeQuery = await _equipmentSizeService.Query(p => p.updateTime >= reqTime);
                List<EquipmentSizeDto> sizeDto = new List<EquipmentSizeDto>();
                Mapper.Map(sizeQuery, sizeDto);
                var src = new ApiResult
                {
                    code = ResultCode.OPERATE_SUCCESS.Code,
                    msg = ResultCode.OPERATE_SUCCESS.Msg,
                    data = sizeDto
                };
               
                return JsonConvert.SerializeObject(src);
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,

                };
                return JsonConvert.SerializeObject(error); 
            }

        }
        /// <summary>
        /// 查询车辆信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]

        public async Task<string> GetCar([FromBody] CommonReq req)
        {

            try
            {
                DateTime reqTime = DateTime.MinValue;
                if (!string.IsNullOrEmpty(req.updateTime))
                {
                    reqTime = DateTime.Parse(req.updateTime);
                }
                var carQuery = await _carService.Query(p => p.updateTime >= reqTime);
                var src = new ApiResult
                {
                    code = ResultCode.OPERATE_SUCCESS.Code,
                    msg = ResultCode.OPERATE_SUCCESS.Msg,
                    data = carQuery
                };

                return JsonConvert.SerializeObject(src);
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,

                };
                return JsonConvert.SerializeObject(error);
            }

        }

        /// <summary>
        /// 查询当前时间信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]

        public async Task<string> GetTime()
        {
            try
            {

                var src = new ApiResult
                {
                    code = ResultCode.OPERATE_SUCCESS.Code,
                    msg = ResultCode.OPERATE_SUCCESS.Msg,
                    data = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")
            };

                return JsonConvert.SerializeObject(src);
            }
            catch (Exception ex)
            {
                var error = new ApiResult
                {
                    code = ResultCode.OPERATE_FAILED.Code,
                    msg = ex.Message,

                };
                return JsonConvert.SerializeObject(error);
            }
         
        }
        /// <summary>
        /// 发送消息队列测试
        /// </summary>
        /// <returns></returns>
        [HttpPost]

        public async Task<string> SendMQ([FromBody] RecordsReq req)
        {
            
            await RabbitMQContext.SendMessageAsynce(JsonConvert.SerializeObject(req));
            var src = new ApiResult
            {
                code = ResultCode.OPERATE_SUCCESS.Code,
                msg = ResultCode.OPERATE_SUCCESS.Msg
                
            };
            return JsonConvert.SerializeObject(src);
        }
    }
}
