﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.Repository.Bussiness;
using Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class OrderService : BaseService<OrderMain>, IOrderService
    {
        private readonly IOrderMainRepository _orderMainRepository;
        private readonly IOrderDetailRepository _orderDetailRepository;
        public IMapper mapper;

        public OrderService(IOrderMainRepository orderMainRepository, IOrderDetailRepository orderDetailepository, IMapper _mapper)
        {
            base.BaseDal = orderMainRepository;
            _orderMainRepository = orderMainRepository;
            _orderDetailRepository = orderDetailepository;
            mapper = _mapper;
        }

        public Task<object> QueryHandOrder(string warehouseId)
        {
            return _orderMainRepository.QueryHandOrder(warehouseId);
        }

        public async Task<OrderMain?> QueryOrder(Expression<Func<OrderMain, bool>> exp)
        {
            var main = await _orderMainRepository.QueryOne(exp);
            if (main != null) main.DetailList = await _orderDetailRepository.Query(s => s.orderId.Equals(main.id));
            return main;
        }
    }
}
