﻿using AutoMapper;
using Common.Utility.Model;
using Models.SqlModel;
using Models.Table;
using Models.ToolsModel;
using Repositories.IRepository.IBussiness;
using Services.Interface;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class LogService : BaseService<LogSummary>, ILogService
    {
        private readonly ILogSummaryRepository _logSummaryRepository;
        private readonly ILogDetailRepository _logDetailRepository;
        public IMapper mapper;

        public LogService(ILogSummaryRepository logSummaryRepository, ILogDetailRepository logDetailepository, IMapper _mapper)
        {
            base.BaseDal = logSummaryRepository;
            _logSummaryRepository = logSummaryRepository;
            _logDetailRepository = logDetailepository;
            mapper = _mapper;
        }

        public Task<bool> HandUploadResult(long? orgid, HandResultReq req)
        {
            return _logSummaryRepository.HandUploadResult(orgid, req);
        }

        public Task<bool> AddChannelLog(OrderMain? myOrder, LogSummary summary, List<Inventory> newInvs)
        {
            var rs1 = "normal";//bussiness_state
            var rs2 = "normal";//equ_state
            if (myOrder != null)
            {
                if (myOrder.orderType.Equals("out"))//获取装备应设为的状态
                {
                    switch (myOrder.bussinessType)
                    {
                        case "allocate":
                            rs1 = "transfer";
                            break;
                        case "use":
                            rs1 = "take";
                            break;
                        case "remove":
                            rs1 = "remove";
                            break;
                        case "destruction":
                            rs1 = "destruction";
                            rs2 = "destory";
                            break;
                        case "quick":
                            rs1 = "quick";
                            break;
                        case "repair":
                            rs1 = "repair";
                            rs2 = "fix";
                            break;
                        default:
                            break;
                    }
                }
            }

            var inv_states = new Tuple<string, string>(rs1,rs2);

            return _logSummaryRepository.AddChannelLog(myOrder, summary, newInvs, inv_states);
        }

        public Task<bool> AddHandLogs(HandRecordsReq model)
        {
            LogSummary log = mapper.Map<LogSummary>(model);
            log.updateTime = DateTime.Now;
            log.createTime = DateTime.Now;

            foreach (var item in model.equipmentList)
            {
                LogDetail logdetail = mapper.Map<LogDetail>(item);
                logdetail.createTime = DateTime.Now;
                logdetail.updateTime = DateTime.Now;
                logdetail.state = model.outInState;
                log.DetailList.Add(logdetail);
            }

            List<Inventory> inveqList = model.equipmentList?.Select(x => new Inventory()
            {
                updateTime = DateTime.Now,
                epc = x.epc,
                state = x.outInState.ToString()
            }).ToList();
            return _logSummaryRepository.AddHandLogs(log, inveqList);
        }

        public Task<bool> AddLogs(RecordsReq model)
        {
            LogSummary log = mapper.Map<LogSummary>(model);
            log.updateTime = DateTime.Now;
            log.createTime = DateTime.Now;
            if (model.equipmentList != null)
            {
                foreach (var item in model.equipmentList)
                {
                    LogDetail logdetail = mapper.Map<LogDetail>(item);
                    logdetail.createTime = DateTime.Now;
                    logdetail.updateTime = DateTime.Now;
                    logdetail.state = item.outInState;
                    log.DetailList.Add(logdetail);
                }
            }
            if (model.carList != null)
            {
                foreach (var item in model.carList)
                {
                    LogDetail logdetail = new LogDetail();
                    logdetail.createTime = DateTime.Now;
                    logdetail.updateTime = DateTime.Now;
                    logdetail.equipmentName = item.carName;
                    logdetail.equipmentSize = item.carNumber;
                    logdetail.state = item.outInState;
                    log.DetailList.Add(logdetail);
                }
            }

            List<Inventory> inveqList = model.equipmentList?.Select(x => new Inventory()
            {
                updateTime = DateTime.Now,
                epc = x.epc,
                state = x.outInState.ToString()
            }).ToList();
            List<Car> invCarList = model.carList?.Select(x => new Car()
            {
                updateTime = DateTime.Now,
                id = x.carId,
                state = x.outInState.ToString()
            }).ToList();
            return _logSummaryRepository.AddLogs(log, inveqList, invCarList);
        }

    }
}
