﻿using AutoMapper;
using Models.ReqModel;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.Repository.Bussiness;
using Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class InvService : BaseService<InvSummary>, IInvService
    {
        private readonly IInvSummaryRepository _invSummaryRepository;
        private readonly IInvDetailRepository _invDetailRepository;
        public IMapper mapper;
        public InvService(IInvSummaryRepository invSummaryRepository, IInvDetailRepository invDetailRepository, IMapper _mapper)
        {
            base.BaseDal = invSummaryRepository;
            _invSummaryRepository = invSummaryRepository;
            _invDetailRepository = invDetailRepository;
            mapper = _mapper;
        }

        public Task<bool> AddInvLogs(InvReq model, List<Inventory> lostInv)
        {
            InvSummary inv = new InvSummary()
            {
                id = Guid.NewGuid().ToString(),
                useTime = model.useTime,
                useName = model.userName,
                invSum = model.invSum,
                resultSum = model.resultSum,
                createTime = DateTime.Now,
                updateTime = DateTime.Now,
            };

            List<Inventory> inList = new List<Inventory>();
            List<Inventory> lostList = new List<Inventory>();

            foreach (var detail in model.data)
            {
                if(detail.state == 0)
                {
                    inList.Add(new Inventory()
                    {
                        id = detail.invId,
                        state = "0",
                        updateTime = DateTime.Now
                    });
                }else if(detail.state == 1)
                {
                    lostList.Add(new Inventory()
                    {
                        id = detail.invId,
                        lostFlag = "1",
                        updateTime = DateTime.Now
                    });
                }

                if(detail.state != 2)
                {
                    inv.DetailList.Add(new InvDetail()
                    {
                        invId = detail.invId,
                        typeName = detail.typeName,
                        sizeName = detail.sizeName,
                        epc = detail.epc,
                        state = detail.state,
                        createTime = DateTime.Now,
                        updateTime = DateTime.Now,
                    });
                }
                
            }

            var lostIds = lostList.Select(s => s.id);

            List<Inventory> addList = new List<Inventory>();

            foreach(var item in lostInv)
            {
                if (!lostIds.Contains(item.id))
                {
                    addList.Add(item);
                }
            }

            inv.DetailList.AddRange(addList.Select(s => new InvDetail()
            {
                invId = s.id,
                typeName = s.typeName,
                sizeName = s.sizeName,
                epc = s.epc,
                state = 2,
                createTime = DateTime.Now,
                updateTime = DateTime.Now,
            }).ToList());

            inv.overView = $"盘盈{addList.Count()}件,盘亏{lostList.Count()}件,更新在库{inList.Count()}件";

            return _invSummaryRepository.AddInvLogs(inv, inList, lostList, addList);
        }
    }
}
