﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.Repository.Bussiness;
using Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class BussinessInventoryService : BaseService<BussinessInventory>, IBussinessInventoryService
    {
        private readonly IBussinessInventoryRepository _bussinessInventoryRepository;
        private readonly IBussinessInventoryDetailRepository _bussinessInventoryDetailRepository;
        public IMapper mapper;
        public BussinessInventoryService(IBussinessInventoryRepository bussinessInventoryRepository, IBussinessInventoryDetailRepository bussinessInventoryDetailRepository, IMapper _mapper)
        {
            base.BaseDal = bussinessInventoryRepository;
            _bussinessInventoryRepository = bussinessInventoryRepository;
            _bussinessInventoryDetailRepository = bussinessInventoryDetailRepository;
            mapper = _mapper;
        }

        public Task<BussinessInventory>? GenerateInventoryOrder(BussinessInventory myBIOrder)
        {
            return _bussinessInventoryRepository.GenerateInventoryOrder(myBIOrder);
        }

        public Task<bool> OrderRollBack(BussinessInventory myBIOrder)
        {
            return _bussinessInventoryRepository.OrderRollBack(myBIOrder);
        }
    }
}
