﻿using Models.ToolsModel;
using Repositories.IRepository;
using Services.Interface;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace Services
{
    public class BaseService<TEntity> : IBaseServices<TEntity> where TEntity : class, new()
    {


        protected BaseResponse<T> Result<T>(T t, StatusCode code, string msg)
        {
            return BaseResponse<T>.GetResponse(t, code, msg);
        }

        protected BaseResponse<T> Result<T>(T t)
        {
            return BaseResponse<T>.GetResponse(t, StatusCode.Success, string.Empty);
        }

        public IBaseRepository<TEntity> BaseDal;

        public async Task<int> Add(TEntity entity)
        {
            return await BaseDal.Add(entity);
        }
        public async Task<List<TEntity>> Query()
        {
            return await BaseDal.Query();
        }

        public async Task<int> Add(List<TEntity> listEntity)
        {
            return await BaseDal.Add(listEntity);
        }
        public async Task<bool> DeleteByIds(int[] ids)
        {
            return await BaseDal.DeleteByIds(ids);
        }
        public async Task<bool> Update(TEntity entity)
        {
            return await BaseDal.Update(entity);
        }
        public  int  UpdateObjs(List<TEntity> entity)
        {
            return  BaseDal.UpdateObjs(entity);
        }
        public async Task<bool> DeleteById(object id)
        {
            return await BaseDal.DeleteById(id);
        }

        public async Task<TEntity> QueryOneOrder(Expression<Func<TEntity, bool>> whereExpression, Expression<Func<TEntity, object>> orderExpression)
        {
            return await BaseDal.QueryOneOrder(whereExpression, orderExpression);
        }

        public async Task<TEntity> QueryOneOrderDesc(Expression<Func<TEntity, bool>> whereExpression, Expression<Func<TEntity, object>> orderExpression)
        {
            return await BaseDal.QueryOneOrderDesc(whereExpression, orderExpression);
        }


        public async Task<TEntity> QueryOne(Expression<Func<TEntity, bool>> whereExpression)
        {
            return await BaseDal.QueryOne(whereExpression);
        }

        public async Task<List<TEntity>> Query(Expression<Func<TEntity, bool>> whereExpression)
        {
            return await BaseDal.Query(whereExpression);
        }

        public async Task<List<T>> Query<T>(Expression<Func<T, bool>> whereExpression, Expression<Func<T, object>> includeExpression)
        {
            return await BaseDal.Query(whereExpression, includeExpression);
        }

        public async Task<PageModel<TEntity>> QueryPage(Expression<Func<TEntity, bool>> whereExpression,
       int intPageIndex = 1, int intPageSize = 20, string strOrderByFileds = null)
        {
            return await BaseDal.QueryPage(whereExpression,
         intPageIndex, intPageSize, strOrderByFileds);
        }

        public async Task<PageModel<TResult>> QueryMuch<T, T2, T3, TResult>(
            int intPageIndex,
            int intPageSize,
            string strOrderByFileds,
            string where,
            Expression<Func<T, T2, T3, object[]>> joinExpression,
            Expression<Func<T, T2, T3, TResult>> selectExpression
           ) where T : class, new()
        {
            return await BaseDal.QueryMuch(
                intPageIndex,
                intPageSize,
                strOrderByFileds,
                where,
                joinExpression,
                selectExpression
                );
        }
    }
}
