﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class PoliceFingerRepository : BaseRepository<PoliceFinger>, IPoliceFingerRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public PoliceFingerRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<bool> UpdateFinger(string policeId, List<PoliceFinger> fingers)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    fingers.ForEach(s =>
                    {
                        s.policeId = policeId;
                        s.createTime = DateTime.Now;
                        s.updateTime = DateTime.Now;
                    });

                    //新增或更新
                    //var x = context.Storageable(fingers).WhereColumns(s => new { s.policeId, s.fingerNum }).ToStorage();
                    //x.AsInsertable.IgnoreColumns(s => s.id).ExecuteCommand();
                    //x.AsUpdateable.WhereColumns(s => new { s.policeId, s.fingerNum })//查询字段
                    //    .UpdateColumns(s => new { s.fingerInfo, s.updateTime })//更新字段
                    //    //.IgnoreColumns(s => new { s.policeId, s.fingerNum, s.createTime })//不更新字段
                    //    .ExecuteCommand();

                    var fingerinfo = context.Queryable<PoliceFinger>().Where(s => s.policeId.Equals(policeId)).ToList();
                    var updateDic = fingerinfo.Select(s => s.fingerNum).ToList();

                    var updateList = new List<PoliceFinger>();
                    var insertList = new List<PoliceFinger>();
                    fingers.ForEach(s =>
                    {
                        if (updateDic.Contains(s.fingerNum))
                        {
                            updateList.Add(s);
                        }
                        else
                        {
                            insertList.Add(s);
                        }
                    });

                    if (insertList.Any()) context.Insertable(insertList).ExecuteCommand();
                    if (updateList.Any()) context.Updateable(updateList)
                            .WhereColumns(it => new { it.policeId, it.fingerNum })
                            .UpdateColumns(it => new { it.fingerInfo, it.updateTime })
                            .ExecuteCommand();

                    return true;
                }
                catch (Exception e)
                {
                    return false;
                }
            }
        }
    }
}
