﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class OrderMainRepository : BaseRepository<OrderMain>, IOrderMainRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public OrderMainRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<object> QueryHandOrder(string warehouseId)
        {
            using (var context = _suger.GetDbClient())
            {
                //var orders = await context.Queryable<OrderDetail>()
                //    .RightJoin<OrderMain>((c, j) => c.orderId == j.id)
                //    .Where((c, j) => c.warehouseId.Equals(warehouseId) && c.createTime.Equals(c.updateTime) && j.orderState == 0)
                //    //.Select<dynamic>((c, j) => new { id = c.id.SelectAll(), bussinessType = j.bussinessType, orderType = j.orderType })
                //    .ToListAsync();

                //var mainids = orders.GroupBy(s => s.orderId).Select(s => s.Key).ToList();

                object result = await context.Queryable<OrderMain>()
                    .RightJoin<OrderDetail>((c, j) => c.id == j.orderId)
                    .Where((c, j) => j.warehouseId.Equals(warehouseId) && j.createTime.Equals(j.updateTime) && c.orderState == 0)
                    .Select(c => new 
                    {
                        orderId = c.id,
                        c.bussinessType,
                        c.invList,
                        c.inventoryQuantity,
                        c.orderType,
                        c.orderCode,
                        c.createTime,
                        detailList = SqlFunc.Subqueryable<OrderDetail>().Where(s => s.orderId.Equals(c.id)).ToList(),
                    }).ToListAsync(); ;


                return result;
            }
        }

    }
}
