﻿using AutoMapper;
using Common.Utility.Model;
using Models.SqlModel;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class LogSummaryRepository : BaseRepository<LogSummary>, ILogSummaryRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public LogSummaryRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<bool> HandUploadResult(long? orgid, HandResultReq req)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    context.BeginTran();

                    //更新主单
                    var mainOrder = context.Queryable<OrderMain>().First(x => x.id.Equals(req.order.orderId));
                    mainOrder.actualQuantity += req.order.actualNum;
                    mainOrder.price += req.order.price;
                    mainOrder.updateTime = DateTime.Now;

                    context.Updateable(mainOrder)
                        .WhereColumns(s => new { s.actualQuantity, s.price, s.updateTime })
                        .ExecuteCommand();

                    //更新子单
                    req.order.updateTime = DateTime.Now;
                    context.Updateable(req.order)
                        .WhereColumns(s => new { s.actualNum, s.price, s.updateTime })
                        .PublicSetColumns(s => s.price, "+")//price += s.price
                        .PublicSetColumns(s => s.actualNum, "+")
                        .ExecuteCommand();

                    //新装备
                    bool isNewEqu = false;
                    bool isPurchase = false;
                    List<Inventory> newEquList = new List<Inventory>();
                    List<PrintDetail> periodInfoList = new List<PrintDetail>();//采购装备质保期维保期生产日期等信息

                    List<string> newEquOrderType = new List<string>() { "purchase", "gift", "allocate" };
                    if (newEquOrderType.Contains(mainOrder.bussinessType) && mainOrder.orderType.Equals("in"))
                    {
                        isNewEqu = true;
                        periodInfoList = context.Queryable<PrintDetail>().Where(s => s.orderId.Equals(mainOrder.id)).ToList();
                        if (mainOrder.bussinessType.Equals("purchase"))
                        {
                            isPurchase = true;
                        }
                    }

                    List<string> InventoryIds = new List<string>();

                    //出入库记录
                    var supplierDic = context.Queryable<Supplier>().ToList();

                    req.logList.ForEach(s => 
                    {
                        s.isUpload = 0;
                        s.useTime = DateTime.Now;
                        s.createTime = DateTime.Now;
                        s.updateTime = DateTime.Now;
                        s.DetailList.ForEach(c =>
                        {
                            var mySup = supplierDic.FirstOrDefault(a => a.code.Equals(c.supplierName));

                            if (!string.IsNullOrEmpty(c.inventoryId)) InventoryIds.Add(c.inventoryId);

                            c.createTime = DateTime.Now;
                            c.updateTime = DateTime.Now;
                            c.errorState = 0;
                            c.state = s.outInState == "in" ? 0 : 1;
                            c.supplierId = mySup?.id;
                            c.supplierName = mySup?.name;

                            //新装备
                            if (isNewEqu)
                            {
                                var equ = new Inventory()
                                {
                                    id = Guid.NewGuid().ToString(),
                                    equipmentType = "0",
                                    typeId = c.equipmentTypeId,
                                    typeName = c.equipmentName,
                                    sizeId = c.equipmentSizeId,
                                    sizeName = c.equipmentSize,
                                    supplierId = mySup?.id,
                                    supplierName = mySup?.name,
                                    epc = c.epc,
                                    orgId = orgid,
                                    state = "0",
                                    lostFlag = "0",
                                    price = c.price,
                                    locationType = "0",
                                    locationId = s.locationId,
                                    equState = "normal",
                                    bussinessState = "normal",
                                    createTime = DateTime.Now,
                                    updateTime = DateTime.Now,
                                };

                                c.inventoryId = equ.id;

                                if (isPurchase)
                                {
                                    var myperiod = periodInfoList?.FirstOrDefault(b => b.sizeId.Equals(c.equipmentSizeId));
                                    equ.state = "2";
                                    equ.maintenancePeriod = myperiod?.maintenancePeriod?.ToString();
                                    equ.warrantyPeriod = myperiod?.warrantyPeriod?.ToString();
                                    equ.productionDate = myperiod?.productionDate;
                                }
                                newEquList.Add(equ);
                            }
                        });
                    });

                    context.Insertable(req).ExecuteCommand();

                    if(newEquList != null && newEquList.Count() > 0)
                    {
                        context.Insertable(newEquList).ExecuteCommand();
                    }

                    #region 更新装备状态
                    var target_bussinessState = "normal";
                    var target_equState = "normal";

                    if (mainOrder.orderType.Equals("out"))//获取装备应设为的状态
                    {
                        switch (mainOrder.bussinessType)
                        {
                            case "allocate":
                                target_bussinessState = "transfer";
                                break;
                            case "use":
                                target_bussinessState = "take";
                                break;
                            case "remove":
                                target_bussinessState = "remove";
                                break;
                            case "destruction":
                                target_bussinessState = "destruction";
                                target_equState = "destory";
                                break;
                            case "repair":
                                target_bussinessState = "repair";
                                target_equState = "fix";
                                break;
                            default:
                                break;
                        }
                    }

                    if(InventoryIds.Count() > 0)
                    {
                        context.Updateable<Inventory>()
                            .Where(s => InventoryIds.Contains(s.id))
                            .ReSetValue(it => 
                            { 
                                it.bussinessState = target_bussinessState;
                                it.equState = target_equState;
                                it.updateTime = DateTime.Now;
                            })
                            .ExecuteCommand();
                    }
                    #endregion

                    context.CommitTran();

                    return true;
                }
                catch (Exception e)
                {
                    return false;
                }
            }
        }

        public async Task<bool> AddChannelLog(OrderMain? myOrder, LogSummary summary, List<Inventory> newInvs, Tuple<string,string> inv_states)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    context.BeginTran();

                    if(newInvs != null && newInvs.Count() > 0)
                    {
                        var inv_rs = context.Insertable(newInvs).ExecuteCommand();

                        //采购单据的出入库记录加入库存id
                        summary.DetailList.ForEach(s =>
                        {
                            s.inventoryId = context.Queryable<Inventory>().First(n => n.epc.Equals(s.epc))?.id;
                        });
                    }

                    var logrs = context.InsertNav(summary).Include(z1 => z1.DetailList).ExecuteCommand();

                    //更新库存状态
                    var state = newInvs != null && newInvs.Count() > 0 ? "2" : summary.outInState.Equals("out") ? "1" : "0";
                    var invIds = summary.DetailList.Select(a => a.inventoryId).ToList();
                    context.Updateable<Inventory>().Where(s => invIds.Contains(s.id))
                        .SetColumns(i => new Inventory() 
                        {  
                            state = state, 
                            bussinessState = inv_states.Item1, 
                            equState = inv_states.Item2, 
                            updateTime = DateTime.Now 
                        }).ExecuteCommand();

                    //更新单据
                    if (myOrder != null)
                    {
                        //子表
                        var ids = context.Queryable<LogSummary>()
                            .Where(s => s.orderId.Equals(myOrder.id))
                            .Select(s => s.id).ToList();

                        List<LogDetail> details = context.Queryable<LogDetail>()
                            .Where(s => ids.Contains(s.summaryId)).ToList();

                        var detailSumDic = details
                            .GroupBy(s => new { s.equipmentSizeId, s.epc })//避免1个EPC重复出入库导致单据反复计数
                            .Select(s => new { size = s.Key.equipmentSizeId, epc = s.Key.epc })
                            .GroupBy(s => s.size)
                            .Select(s => new { size = s.Key, count = s.Count() })
                            .ToDictionary(s => s.size, s => s.count);

                        foreach (var item in myOrder.DetailList)
                        {
                            if (detailSumDic.ContainsKey(item.equipmentSize))
                            {
                                item.actualNum = detailSumDic[item.equipmentSize];
                            }
                        }

                        //主表
                        decimal sumPrice = Convert.ToDecimal(myOrder.DetailList.Select(s => s.actualNum * s.price).Sum());

                        myOrder.actualQuantity = summary.number;
                        myOrder.price = sumPrice;
                        myOrder.isUpload = 1;
                        //myOrder.orderState = 0;
                        myOrder.updateTime = DateTime.Now;

                        var orderrs = context.UpdateNav(myOrder).Include(z1 => z1.DetailList).ExecuteCommand();

                        //调拨领用出库删除装备
                        if (inv_states.Item1.Equals("transfer") || inv_states.Item1.Equals("take"))
                        {
                            context.Deleteable<Inventory>().Where(s => invIds.Contains(s.id)).ExecuteCommand();
                        }
                    }

                    context.CommitTran();
                }
                catch (Exception e)
                {
                    return false;
                }
            }
            return true;
        }

        public async Task<bool> AddHandLogs(LogSummary model, List<Inventory> inv)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    context.BeginTran();

                    var result = context.Updateable(inv).WhereColumns(it => new { it.epc }).UpdateColumns(it => new { it.state, it.updateTime }).ExecuteCommand();//实体有多少列更新多少列
                    var logSum = context.InsertNav(model)
                        .Include(z1 => z1.DetailList)
                        .ExecuteCommand();

                    context.CommitTran();

                }
                catch (Exception e)
                {
                    throw e;
                }
            }
            return true;
        }

        public async Task<bool> AddLogs(LogSummary model, List<Inventory> inv, List<Car> cars)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    //var invs = await context.Queryable<Inventory>().Where(x =>
                    //model.DetailList.Select(x => x.epc).Contains(x.epc)).ToListAsync();

                    var cabinetInv = inv.Where(s => s.state == "0").ToList();

                    for(int i = 0; i < cabinetInv.Count(); i++)
                    {
                        cabinetInv[i].locationType = "1";
                    }

                    context.BeginTran();

                    context.Updateable(cars).WhereColumns(it => new { it.id }).UpdateColumns(it => new { it.state, it.updateTime }).ExecuteCommand();//实体有多少列更新多少列

                    var result = context.Updateable(inv).WhereColumns(it => new { it.epc }).UpdateColumns(it => new { it.state, it.updateTime }).ExecuteCommand();//实体有多少列更新多少列

                    var result1 = context.Updateable(cabinetInv).WhereColumns(it => new { it.epc }).UpdateColumns(it => new { it.locationType }).ExecuteCommand();

                    var logSum = context.InsertNav(model)
                        .Include(z1 => z1.DetailList)
                        .ExecuteCommand();

                    context.CommitTran();

                }
                catch (Exception e)
                {
                    throw e;
                }
            }
            return true;
        }

    }
}
