﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class InvSummaryRepository : BaseRepository<InvSummary>, IInvSummaryRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public InvSummaryRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<bool> AddInvLogs(InvSummary model, List<Inventory> inList, List<Inventory> lostList, List<Inventory> getList)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    context.BeginTran();

                    var result1 = context.Updateable(inList).WhereColumns(it => new { it.id }).UpdateColumns(it => new { it.state, it.updateTime }).ExecuteCommand();

                    var result2 = context.Updateable(lostList).WhereColumns(it => new { it.id }).UpdateColumns(it => new { it.lostFlag, it.updateTime }).ExecuteCommand();

                    var result3 = context.Updateable(getList).WhereColumns(it => new { it.id }).UpdateColumns(it => new { it.lostFlag, it.updateTime }).ExecuteCommand();

                    var linvSum = context.InsertNav(model)
                        .Include(z1 => z1.DetailList)
                        .ExecuteCommand();

                    context.CommitTran();

                    return true;
                }
                catch (Exception e)
                {
                    throw e;
                }
            }
        }
    }
}
