﻿using AutoMapper;
using Models.Table;
using Repositories.IRepository.IBussiness;
using Repositories.IRepository.IUnitOfWork;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Repositories.Repository.Bussiness
{
    public class BussinessInventoryRepository : BaseRepository<BussinessInventory>, IBussinessInventoryRepository
    {
        protected readonly ILocalSugarUnitOfWork _suger;
        public IMapper mapper;
        public BussinessInventoryRepository(ILocalSugarUnitOfWork sugarUnitOfWork) : base(sugarUnitOfWork)
        {
            _suger = sugarUnitOfWork;
        }

        public async Task<BussinessInventory>? GenerateInventoryOrder(BussinessInventory myBIOrder)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    List<Inventory> inventory = new List<Inventory>();
                    switch (myBIOrder.inventoryType)
                    {
                        case "0"://全盘
                            inventory = await context.Queryable<Inventory>()
                                .Where(s => s.locationId.Equals(myBIOrder.warehouseId) && !s.bussinessState.Equals("destruction") && !s.equState.Equals("destory"))
                                .ToListAsync();

                            break;
                        case "1"://类别盘点
                            if (string.IsNullOrEmpty(myBIOrder.rules))
                            {
                                return null;
                            }
                            List<string> types = myBIOrder.rules.Split(',').ToList();
                            inventory = await context.Queryable<Inventory>()
                                .Where(s => s.locationId.Equals(myBIOrder.warehouseId) && !s.bussinessState.Equals("destruction") && !s.equState.Equals("destory")
                                && types.Contains(s.typeId))
                                .ToListAsync();

                            break;
                        case "2"://号型盘点
                            if (string.IsNullOrEmpty(myBIOrder.rules))
                            {
                                return null;
                            }
                            List<string> sizes = myBIOrder.rules.Split(',').ToList();
                            inventory = await context.Queryable<Inventory>()
                                .Where(s => s.locationId.Equals(myBIOrder.warehouseId) && !s.bussinessState.Equals("destruction") && !s.equState.Equals("destory")
                                && sizes.Contains(s.sizeId))
                                .ToListAsync();

                            break;
                        default:
                            return null;
                    }

                    List<BussinessInventoryDetail> classifyInventory = inventory
                                .GroupBy(s => new { s.typeId, s.typeName, s.sizeId, s.sizeName })
                                .Select(s => new BussinessInventoryDetail
                                {
                                    inventoryId = myBIOrder.id,
                                    typeId = s.Key.typeId,
                                    typeName = s.Key.typeName,
                                    sizeId = s.Key.sizeId,
                                    sizeName = s.Key.sizeName,
                                    stockNumber = s.Count(),
                                    createTime = DateTime.Now,
                                    updateTime = DateTime.Now,
                                    fixNumber = 0,
                                    fixPrice = 0,
                                    num = 0,
                                })
                                .ToList();

                    context.BeginTran();

                    context.Insertable(classifyInventory).ExecuteCommand();

                    myBIOrder.totalNum = classifyInventory.Sum(s => s.stockNumber);
                    myBIOrder.updateTime = DateTime.Now;
                    myBIOrder.inventoryState = "running";
                    context.Updateable(myBIOrder).UpdateColumns(it => new { it.totalNum, it.updateTime, it.inventoryState }).ExecuteCommand();

                    context.CommitTran();

                    var rs = myBIOrder;
                    rs.DetailList = classifyInventory;

                    return rs;
                }
                catch (Exception e)
                {
                    return null;
                }
            }
        }

        public async Task<bool> OrderRollBack(BussinessInventory myBIOrder)
        {
            using (var context = _suger.GetDbClient())
            {
                try
                {
                    context.BeginTran();

                    myBIOrder.updateTime = DateTime.Now;
                    myBIOrder.inventoryState = "waitting";
                    context.Updateable(myBIOrder).UpdateColumns(it => new { it.updateTime, it.inventoryState }).ExecuteCommand();

                    context.Deleteable<BussinessInventoryDetail>().Where(it => it.inventoryId == myBIOrder.id).ExecuteCommand();

                    context.CommitTran();

                    return true;
                }
                catch (Exception e)
                {
                    return false;
                }
            }
        }
    }
}
