﻿using System;
using System.Collections.Generic;
using System.Linq;
using SqlSugar;
namespace Models.Table
{
    /// <summary>
    /// 
    ///</summary>
    [SugarTable("base_policeman")]
    public class PoliceInfo : BaseTable
    {
        /// <summary>
        /// 警员id 
        ///</summary>
         [SugarColumn(ColumnName="id" ,IsPrimaryKey = true   )]
         public string id { get; set; }
        /// <summary>
        /// 警员名称 
        ///</summary>
         [SugarColumn(ColumnName="name"    )]
         public string name { get; set; }
        /// <summary>
        /// 新版本组织机构外键 
        ///</summary>
         [SugarColumn(ColumnName="org_id"    )]
         public long? orgId { get; set; }
        /// <summary>
        /// 警员编号 
        ///</summary>
         [SugarColumn(ColumnName="police_code"    )]
         public string policeCode { get; set; }
        /// <summary>
        /// 人脸信息 
        ///</summary>
         [SugarColumn(ColumnName="face_info"    )]
         public string faceInfo { get; set; }
        /// <summary>
        /// 门禁使用编码 
        ///</summary>
         [SugarColumn(ColumnName="door_code"    )]
         public string doorCode { get; set; }
        /// <summary>
        /// 密码 
        ///</summary>
         [SugarColumn(ColumnName="password"    )]
         public string password { get; set; }
        /// <summary>
        /// 警员照片 
        ///</summary>
         [SugarColumn(ColumnName="photo"    )]
         public string photo { get; set; }
        /// <summary>
        /// 联系方式（短号） 
        ///</summary>
         [SugarColumn(ColumnName="phone"    )]
         public string phone { get; set; }
        /// <summary>
        /// 联系方式（长号） 
        ///</summary>
         [SugarColumn(ColumnName="tel"    )]
         public string tel { get; set; }
        /// <summary>
        /// 身份证信息 
        ///</summary>
         [SugarColumn(ColumnName="id_card"    )]
         public string idCard { get; set; }
        /// <summary>
        /// 状态，1表启用，0表禁用 
        ///</summary>
         [SugarColumn(ColumnName="state"    )]
         public int state { get; set; }
        /// <summary>
        /// 用户id（账号id） 
        ///</summary>
         [SugarColumn(ColumnName="user_id"    )]
         public long? userId { get; set; }
        /// <summary>
        /// 警员身份（0表示警员，1表示辅警） 
        ///</summary>
         [SugarColumn(ColumnName="identity"    )]
         public int? identity { get; set; }
        /// <summary>
        /// 海康人脸机 
        ///</summary>
         [SugarColumn(ColumnName="hk_face_device"    )]
         public int HkFaceDevice { get; set; }
    }
}
