﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Models.Table
{
    [SugarTable("bussiness_order_main")]
    public class OrderMain : BaseTable
    {
        [SugarColumn(IsPrimaryKey = true)]
        public string id { get; set; }

        [SugarColumn(ColumnName = "order_type")]
        public string orderType { get; set; }

        [SugarColumn(ColumnName = "bussiness_type")]
        public string bussinessType { get; set; }

        [SugarColumn(ColumnName = "order_code")]
        public string orderCode { get; set; }

        [SugarColumn(ColumnName = "start_org_id")]
        public long? startOrgId { get; set; }

        [SugarColumn(ColumnName = "start_org_name")]
        public string startOrgName { get; set; }

        [SugarColumn(ColumnName = "end_org_id")]
        public long? endOrgId { get; set; }

        [SugarColumn(ColumnName = "end_org_name")]
        public string endOrgName { get; set; }

        [SugarColumn(ColumnName = "supplier_name")]
        public string supplierName { get; set; }

        [SugarColumn(ColumnName = "start_org_user_id")]
        public string startOrgUserId { get; set; }

        [SugarColumn(ColumnName = "start_org_user_name")]
        public string startOrgUserName { get; set; }

        [SugarColumn(ColumnName = "end_org_user_id")]
        public string endOrgUserId { get; set; }

        [SugarColumn(ColumnName = "end_org_user_name")]
        public string endOrgUserName { get; set; }

        public decimal? price { get; set; }

        [SugarColumn(ColumnName = "inventory_quantity")]
        public int? inventoryQuantity { get; set; }

        [SugarColumn(ColumnName = "actual_quantity")]
        public int? actualQuantity { get; set; }

        [SugarColumn(ColumnName = "order_state")]
        public int? orderState { get; set; }

        [SugarColumn(ColumnName = "attachment_location")]
        public string attachmentLocation { get; set; }

        [SugarColumn(ColumnName = "inv_list")]
        public string invList { get; set; }

        public string note { get; set; }

        [SugarColumn(ColumnName = "form_item")]
        public string formItem { get; set; }

        [SugarColumn(ColumnName = "return_data")]
        public string returnData { get; set; }

        [SugarColumn(ColumnName = "use_date")]
        public DateTime? useDate { get; set; }

        [SugarColumn(ColumnName = "create_user")]
        public string createUser { get; set; }

        [SugarColumn(ColumnName = "update_user")]
        public string updateUser { get; set; }

        public int? isUpload { get; set; }

        [Navigate(NavigateType.OneToMany, nameof(OrderDetail.orderId))]
        public List<OrderDetail> DetailList { get; set; } = new List<OrderDetail>();
    }
}
