﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Principal;
using System.Text;
using System.Threading.Tasks;

namespace Models.Table
{

    [SugarTable("base_log_summary")]
    public class LogSummary : BaseTable
    {
        [SugarColumn(IsIdentity = true, IsPrimaryKey = true)]
        public int id { get; set; }

        [SugarColumn(ColumnName = "cabinet_id")]
        public string cabinetId { get; set; }
    
        public int type { get; set; }

        [SugarColumn(ColumnName = "user_name")]
        public string userName { get; set; }

        public string equipments { get; set; }

        [SugarColumn(ColumnName = "use_time")]
        public DateTime? useTime { get; set; }

        [SugarColumn(ColumnName = "order_id")]
        public string orderId { get; set; }

        [SugarColumn(ColumnName = "order_code")]
        public string orderCode { get; set; }

        [SugarColumn(ColumnName = "bussiness_type")]
        public string bussinessType { get; set; }

        [SugarColumn(ColumnName = "device")]
        public string device { get; set; }

        [SugarColumn(ColumnName = "device_type")]
        public int? deviceType { get; set; }

        [SugarColumn(ColumnName = "location_id")]
        public string locationId { get; set; }

        [SugarColumn(ColumnName = "location_name")]
        public string locationName { get; set; }

        [SugarColumn(ColumnName = "out_in_state")]
        public string outInState { get; set; }

        public string picture { get; set; }

        public int? number { get; set; }

        public int? isUpload { get; set; }

        public decimal? price { get; set; }


        [Navigate(NavigateType.OneToMany, nameof(LogDetail.summaryId))]
        public List<LogDetail> DetailList { get; set; } = new List<LogDetail>();

    }
}
