﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Models.Table
{
    [SugarTable("base_inv_summary")]
    public class InvSummary : BaseTable
    {
        [SugarColumn(IsPrimaryKey = true)]
        public String id { get; set; }
        [SugarColumn(ColumnName = "use_time")]
        public DateTime? useTime { get; set; }
        [SugarColumn(ColumnName = "user_name")]
        public String? useName { get; set; }
        [SugarColumn(ColumnName = "inv_sum")]
        public int? invSum { get; set; }
        [SugarColumn(ColumnName = "result_sum")]
        public int? resultSum { get; set; }
        public String? overView { get; set; }
        [SugarColumn(ColumnName = "org_id")]
        public String orgId { get; set; }
        [SugarColumn(ColumnName = "location_id")]
        public String locationId { get; set; }
        [SugarColumn(ColumnName = "location_name")]
        public String locationName { get; set; }


        [Navigate(NavigateType.OneToMany, nameof(InvDetail.summaryId))]
        public List<InvDetail> DetailList { get; set; } = new List<InvDetail>();
    }
}
