﻿using System;
using System.Collections.Generic;
using System.Linq;
using Models;
using SqlSugar;
namespace Models.Table
{
    /// <summary>
    /// 
    ///</summary>
    [SugarTable("bussiness_inventory")]
    public class BussinessInventory : BaseTable
    {
        /// <summary>
        ///  
        ///</summary>
         [SugarColumn(ColumnName="id" ,IsPrimaryKey = true   )]
         public long id { get; set; }
        /// <summary>
        /// 订单号 
        ///</summary>
         [SugarColumn(ColumnName="order_num"    )]
         public string orderNum { get; set; }
        /// <summary>
        /// 年度 
        ///</summary>
         [SugarColumn(ColumnName="year"    )]
         public int? year { get; set; }
        /// <summary>
        /// 月份 
        ///</summary>
         [SugarColumn(ColumnName="month"    )]
         public int? month { get; set; }
        /// <summary>
        /// 申请时间 
        ///</summary>
         [SugarColumn(ColumnName="apply_time"    )]
         public DateTime? applyTime { get; set; }
        /// <summary>
        /// 仓库id 
        ///</summary>
         [SugarColumn(ColumnName="warehouse_id"    )]
         public string warehouseId { get; set; }
        /// <summary>
        /// 仓库名称 
        ///</summary>
         [SugarColumn(ColumnName="warehouse_name"    )]
         public string warehouseName { get; set; }
        /// <summary>
        /// 组织机构Id 
        ///</summary>
         [SugarColumn(ColumnName="org_id"    )]
         public long? orgId { get; set; }
        /// <summary>
        /// 组织机构名称 
        ///</summary>
         [SugarColumn(ColumnName="org_name"    )]
         public string orgName { get; set; }
        /// <summary>
        /// 盘点状态，waitting等待盘点，running盘点中，finished完成，cancel取消,close结算 
        ///</summary>
         [SugarColumn(ColumnName="inventory_state"    )]
         public string inventoryState { get; set; }
        /// <summary>
        /// 盘点类型，0全盘，1按类别盘点,2按照号型盘点 
        ///</summary>
         [SugarColumn(ColumnName="inventory_type"    )]
         public string inventoryType { get; set; }
        /// <summary>
        /// 类别id汇总，用逗号分割 
        ///</summary>
         [SugarColumn(ColumnName="rules"    )]
         public string rules { get; set; }
        /// <summary>
        /// 展示汇总(不返回) 
        ///</summary>
         [SugarColumn(ColumnName="rules_json"    )]
         public string rulesJson { get; set; }
        /// <summary>
        /// 应盘总数 
        ///</summary>
         [SugarColumn(ColumnName="total_num"    )]
         public int? totalNum { get; set; }
        /// <summary>
        /// 实际总数 
        ///</summary>
         [SugarColumn(ColumnName="actual_num"    )]
         public int? actualNum { get; set; }
        /// <summary>
        /// 亏损总数 
        ///</summary>
         [SugarColumn(ColumnName="add_num"    )]
         public int? addNum { get; set; }
        /// <summary>
        /// 盈余总数 
        ///</summary>
         [SugarColumn(ColumnName="delete_num"    )]
         public int? deleteNum { get; set; }
        /// <summary>
        /// 盘点结果，ready未开始,surplus盈余，loss亏损，normal正常，surplus&amp;loss既有盈余，也有亏损 
        ///</summary>
         [SugarColumn(ColumnName="result"    )]
         public string result { get; set; }
        /// <summary>
        /// 原有epc备份(不返回) 
        ///</summary>
         [SugarColumn(ColumnName="epc_back"    )]
         public string epcBack { get; set; }
        /// <summary>
        /// 需要更新的epc汇总 
        ///</summary>
         [SugarColumn(ColumnName="epc_update"    )]
         public string epcUpdate { get; set; }

        [Navigate(NavigateType.OneToMany, nameof(BussinessInventoryDetail.inventoryId))]
        public List<BussinessInventoryDetail> DetailList { get; set; } = new List<BussinessInventoryDetail>();
    }
}
