﻿using System.IdentityModel.Tokens.Jwt;
using System.Security.Claims;
using System.Text;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;

namespace Common;

public class JwtHelper
{
    public static string CreateJwt(TokenModelJwt model)
    {
        var claims = new List<Claim>
        {
            new Claim("UserId", model.UserId.ToString()),
            new Claim("UserName", model.UserName),
        };
        if (!string.IsNullOrWhiteSpace(model.Role))
        {
            claims.AddRange(model.Role.Split(',').Select(s => new Claim(ClaimTypes.Role, s)));
            claims.Add(new Claim("Role", model.Role));
        }

        var key = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(model.Secret));
        var creds = new SigningCredentials(key, SecurityAlgorithms.HmacSha256);

        var jwt = new JwtSecurityToken(
            issuer: model.Issuer,
            audience: model.Audience,
            expires: DateTime.Now.AddSeconds(model.Expires),
            signingCredentials: creds,
            claims: claims
        );

        var jwtHandler = new JwtSecurityTokenHandler();
        var token = jwtHandler.WriteToken(jwt);

        return token;
    }

    public static TokenModelJwt SerializeJwt(string jwtStr)
    {
        var jwtToken = new JwtSecurityTokenHandler().ReadJwtToken(jwtStr);
        var tokenJwt = JsonConvert.DeserializeObject<TokenModelJwt>(jwtToken.Payload.SerializeToJson());
        return tokenJwt;
    }

    public class TokenModelJwt
    {
        public int UserId { get; set; }
        public string UserName { get; set; }
        public string Issuer { get; set; }
        public string Audience { get; set; }
        public string Secret { get; set; }
        public int Expires { get; set; }
        public string Role { get; set; }
    }
}