﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace Common
{
    public class HttpHelper
    {
        public static string HttpPost(string strUrl, string json = "")
        {
            try
            {

                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(strUrl);
                request.Method = "POST";

                if (!string.IsNullOrEmpty(json))
                {
                    request.ContentType = "application/json";
                    byte[] data = Encoding.UTF8.GetBytes(json);
                    request.ContentLength = data.Length;
                    using (Stream reqStream = request.GetRequestStream())
                    {
                        reqStream.Write(data, 0, data.Length);
                        reqStream.Close();
                    }
                }
                else { request.ContentLength = 0; }

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string retString = streamReader.ReadToEnd();
                streamReader.Close();
                responseStream.Close();
                response.Close();
                return retString;

            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        public static string HttpGet(string strUrl)
        {
            try
            {

                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(strUrl);
                request.Method = "GET";

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string retString = streamReader.ReadToEnd();
                streamReader.Close();
                responseStream.Close();
                response.Close();
                return retString;

            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        public class res<T> where T : class
        {
            public string code { get; set; }
            public string message { get; set; }
            public T data { get; set; }
            public string timestamp {  get; set; }
        }
    }
}
