﻿using AutoMapper;
using Common.Global;
using JmpDehumidifierLib;
using Models.Table;
using Newtonsoft.Json;
using Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Common
{
    public class DehumidifierHelper
    {
        public IMapper Mapper { get; }

        private readonly IDevHistoryService _devHistoryService;
        private readonly IDevService _devService;

        public DehumidifierHelper(IMapper mapper, IDevHistoryService devHistoryService, IDevService devService)
        {
            _devHistoryService = devHistoryService;
            _devService = devService;
            Mapper = mapper;
        }

        private Dictionary<string, Dehumidifier> devList = new Dictionary<string, Dehumidifier>();
        private Dictionary<string, int?> devStateDic = new Dictionary<string, int?>();//当前状态字典

        public async void StartDehumidifier()
        {
            try
            {
                List<Dev>? devs = await _devService.Query();

                if (devs != null)
                {
                    devList = devs.Select(s => new { Key = s.devIp, Value = new Dehumidifier(s.devIp, Convert.ToInt32(s.devPort)) })
                        .ToDictionary(s => s.Key, s => s.Value);

                    devStateDic = devs.Select(s => new { Key = s.devIp, Value = s.setState })
                        .ToDictionary(s => s.Key, s => s.Value);

                    var openIpList = devs.Where(s => s.setState == 1).Select(s => s.devIp).ToList();

                    foreach (var item in devList)
                    {
                        if (openIpList.Contains(item.Key))
                        {
                            if (item.Value.Open())
                            {
                                try//避免影响设备温湿度获取
                                {
                                    var mySetSd = devs.FirstOrDefault(s => s.devIp.Equals(item.Key))?.setSd;
                                    if (!string.IsNullOrEmpty(mySetSd))
                                    {
                                        item.Value.SetHumid((byte)Convert.ToInt32(mySetSd));
                                    }
                                }
                                catch (Exception ex) { }

                                item.Value.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                                //item.Value.OnStatusChanged += OnStatusChanged;
                            }
                        }
                        else
                        {
                            item.Value.Close();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                //异常处理
            }
        }

        //设定除湿机
        public void SetDehumidifier(Dev myDev)
        {
            try
            {
                if (devStateDic.TryGetValue(myDev.devIp, out int? nowState))
                {
                    if (!devList.ContainsKey(myDev.devIp))
                    {
                        devList.Add(myDev.devIp, new Dehumidifier(myDev.devIp, Convert.ToInt32(myDev.devPort)));
                    }

                    if (nowState != myDev.setState)
                    {
                        if (myDev.setState == 0)
                        {
                            devList[myDev.devIp].OnStatusChanged -= new Dehumidifier.StatusChanged(OnStatusChanged);
                            devList[myDev.devIp].Close();
                        }
                        else if (myDev.setState == 1)
                        {
                            if (devList[myDev.devIp].Open())
                            {
                                //设置湿度
                                if (!string.IsNullOrEmpty(myDev.setSd) || myDev.setSd == "0")
                                {
                                    try
                                    {
                                        devList[myDev.devIp].SetHumid((byte)Convert.ToInt32(myDev.setSd));
                                    }
                                    catch (Exception ex) { }
                                }

                                devList[myDev.devIp].OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                                //item.Value.OnStatusChanged += OnStatusChanged;
                            }
                        }
                    }
                    else if (nowState == 1)
                    {
                        devList[myDev.devIp].SetHumid((byte)Convert.ToInt32(myDev.setSd));
                    }

                }
            }
            catch (Exception ex)
            {
            }
        }

        private Dictionary<string, DevHistory> DevHistoryDic = new Dictionary<string, DevHistory>();

        private async void OnStatusChanged(MachineStatus args)
        {
            try
            {
                if (args.ErrorCode == 0)
                {
                    var devIp = args.ip;
                    var warehouseWd = args.Temp.ToString();  // 室内温度
                    var warehouseSd = args.Humid.ToString(); // 室内湿度
                    var devState = args.IsWorking ? 1 : 0;
                    var devPort = args.port.ToString();

                    var myDev = (await _devService.Query()).FirstOrDefault(s => s.devIp.Equals(devIp));
                    if (myDev != null)
                    {
                        DevHistory record = new DevHistory()
                        {
                            warehouseId = myDev.warehouseId,
                            devCode = myDev.devCode,
                            devIp = devIp,
                            devPort = devPort,
                            devName = myDev.devName,
                            devId = myDev.id,
                            devState = devState,
                            warehouseSd = warehouseSd,
                            warehouseWd = warehouseWd,
                            setSd = myDev.setSd,
                            createTime = DateTime.Now,
                        };

                        if (devStateDic.TryGetValue(devIp, out int? nowState))
                        {
                            if (nowState != devState)
                            {
                                //上报除湿机的状态变更 并更新字典
                                var param = JsonConvert.SerializeObject(new
                                {
                                    devName = record.devName,
                                    warehouseId = record.warehouseId,
                                    devId = record.devId,
                                    state = devState,
                                });
                                HttpHelper.HttpPost(AdminGlobalContext.jyzbConfig.Url + "", param);

                                devStateDic[devIp] = devState;
                            }
                        }

                        if (DevHistoryDic.TryGetValue(devIp, out DevHistory thisHistory))
                        {
                            if (thisHistory.warehouseWd.Equals(record.warehouseWd)
                                && thisHistory.warehouseSd.Equals(record.warehouseSd)
                                && thisHistory.devState == record.devState)
                            {
                                return;
                            }
                            else
                            {
                                DevHistoryDic[devIp] = record;
                            }
                        }
                        else
                        {
                            DevHistoryDic.Add(record.devIp, record);
                        }

                        await _devHistoryService.Add(record);

                        myDev.updateTime = DateTime.Now;
                        myDev.devState = devState;
                        myDev.warehouseSd = warehouseSd;
                        myDev.warehouseWd = warehouseWd;

                        await _devService.Update(myDev);

                        var historypParam = JsonConvert.SerializeObject(new
                        {
                            deviceName = record.devName,
                            warehouseId = record.warehouseId,
                            createTime = (long)(record.createTime.Value - new DateTime(1970, 1, 1)).TotalSeconds,
                            temperature = record.warehouseWd,
                            humidity = record.warehouseSd,
                        });
                        HttpHelper.HttpPost(AdminGlobalContext.jyzbConfig.Url + "", historypParam);
                    }

                    Thread.Sleep(10000);//10s
                }
                else
                {
                    //foreach (var item in devList)
                    //{
                    //    if (item.Key.Equals(args.ip))
                    //    {
                    //        Dehumidifier dev = new Dehumidifier(args.ip, args.port);
                    //        devList.Remove(item.Key);
                    //        devList.Add(args.ip, dev);
                    //        if (dev.Open())
                    //        {
                    //            dev.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                    //        }
                    //    }
                    //}
                    if (devList.TryGetValue(args.ip, out Dehumidifier dehumidifier))
                    {
                        if (dehumidifier.Open())
                        {
                            dehumidifier.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                        }
                    }
                    else
                    {
                        Dehumidifier dev = new Dehumidifier(args.ip, args.port);
                        devList.Add(args.ip, dev);
                        if (dev.Open())
                        {
                            dev.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                        }
                    }

                    Thread.Sleep(30000);//30s
                }
            }
            catch (Exception ex)
            {

            }
        }

    }
}
