﻿using AutoMapper;
using Common;
using Quartz;
using Services.Interface;
using JmpDehumidifierLib;
using Models.Table;
using static JmpDehumidifierLib.Dehumidifier;
using Newtonsoft.Json;
using Common.Global;
using Microsoft.AspNetCore.Mvc.ViewComponents;

namespace APIs.TimedTasks
{
    public class DehumidifierTask : IHostedService
    {
        public IMapper Mapper { get; }

        private readonly DehumidifierHelper _dehumidifierHelper;

        public DehumidifierTask(IMapper mapper, DehumidifierHelper dehumidifierHelper)
        {
            _dehumidifierHelper = dehumidifierHelper;
            Mapper = mapper;
        }

        public async Task StartAsync(CancellationToken cancellationToken)
        {
            try
            {
                _dehumidifierHelper.StartDehumidifier();
            }
            catch (Exception ex)
            {
                //异常处理
            }
        }


        public Task StopAsync(CancellationToken cancellationToken)
        {
            return Task.CompletedTask;
        }
    }
}
