﻿using APIs.Dto;
using APIs.Req;
using AutoMapper;
using Common.Utility.Model;
using Models.SqlModel;
using Models.Table;

namespace APIs.Profiles;

public class MapperProfile : Profile
{
    public MapperProfile()
    {
        CreateMap<EquipmentType, EquipmentTypeDto>().ForMember(dest=>dest.id,opt=>opt.MapFrom(src=>src.id));
        CreateMap<EquipmentSize, EquipmentSizeDto>().ForMember(dest =>dest.id,opt => opt.MapFrom(src => src.id));
        CreateMap<LogSummary, RecordsReq>();
        CreateMap<RecordsReq, LogSummary>();
        CreateMap<LogDetail, EquipmentList>();
        CreateMap<EquipmentList, LogDetail>();

    }
}