﻿using SqlSugar;

namespace APIs.Extensions;

public static class SqlsugarSetup
{
    public static void AddSqlsugarSetup(this IServiceCollection services, IConfiguration configuration,
        string dbName = "MySQL")
    {

        services.AddScoped<ISqlSugarClient>(o =>
        {
            var listConfig = new List<ConnectionConfig>();
            listConfig.Add(new ConnectionConfig()
            {
                ConnectionString = configuration.GetConnectionString(dbName),
                DbType = (SqlSugar.DbType)DbType.MySql,
                IsAutoCloseConnection = true,
                MoreSettings = new ConnMoreSettings()
                {
                    IsAutoRemoveDataCache = true
                }
            });
            return new SqlSugarClient(listConfig);
        });
    }
}