using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;

namespace APIs.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class MemoryController : ControllerBase
    {
        private readonly IMemoryCache _cache;

        public MemoryController(IMemoryCache cache)
        {
            _cache = cache;
        }
        
        [HttpPost]
        public string Set(string name)
        {
            var key = Guid.NewGuid().ToString();
            _cache.Set(key, name, TimeSpan.FromSeconds(300));
            return key;
        }

        [HttpGet]
        public string Get(string key)
        {
            return _cache.Get(key)?.ToString();
        }
    }
}