using Common;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;

namespace APIs.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class JwtController : ControllerBase
    {
        public IConfiguration Configuration { get; }

        public JwtController(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        [HttpPost]
        public string CreateToken()
        {
            var tokenModel = Configuration.GetSection("Jwt").Get<JwtHelper.TokenModelJwt>();
            tokenModel.UserName = "张三";
            tokenModel.UserId = 1;
            tokenModel.Role = "Admin";
            return JwtHelper.CreateJwt(tokenModel);
        }

        [HttpGet]
        [Authorize]
        public IActionResult DeToken([FromHeader]string Authorization)
        {
            var token = JwtHelper.SerializeJwt(Authorization.Replace("Bearer ", ""));
            return Ok(token);
        }
    }
}