﻿using Newtonsoft.Json.Serialization;
using Newtonsoft.Json;
using System.Text;

namespace APIs.Common
{
    public partial class JsonManager
    {
        /// <summary>
        /// 返回成功的结果
        /// </summary>
        /// <param name="body"></param>
        /// <returns></returns>
        public static HttpResponseMessage ReturnSuccessResponse<T>(T data, bool isNull = false)
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", ResultCode.OPERATE_SUCCESS.Code), new JProperty("msg", ResultCode.OPERATE_SUCCESS.Message), new JProperty("body", body)));
            var src = new
            {
                code = ResultCode.OPERATE_SUCCESS.Code,
                msg = ResultCode.OPERATE_SUCCESS.Msg,
                data
            };

            JsonSerializerSettings setting = new JsonSerializerSettings();

            setting.DateFormatHandling = DateFormatHandling.MicrosoftDateFormat;
            setting.DateFormatString = "yyyy-MM-dd HH:mm:ss";
            setting.ContractResolver = new CamelCasePropertyNamesContractResolver();
            setting.MaxDepth = 10; //设置序列化的最大层数
            setting.ReferenceLoopHandling = ReferenceLoopHandling.Ignore;
            if (isNull)
            {
                //空值处理
                setting.NullValueHandling = NullValueHandling.Ignore;
            }

            return new HttpResponseMessage { Content = new StringContent(JsonConvert.SerializeObject(src, Formatting.Indented, setting), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        /// <summary>
        /// 返回执行状态
        /// </summary>
        /// <param name="resultinfo">结果信息</param>
        /// <returns></returns>
        public static HttpResponseMessage SimpleStatusResponse(ResultInfo resultinfo)
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", resultinfo.Code), new JProperty("msg", resultinfo.Message)));
            var src = new
            {
                code = resultinfo.Code,
                msg = resultinfo.Msg,
                timestamp = GetCurrTimeStamp()
            };
            return new HttpResponseMessage { Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(src), Encoding.GetEncoding("UTF-8"), "application/json") };
        }
        /// <summary>
        /// 获取当前时间戳
        /// </summary>
        /// <returns></returns>
        public static long GetCurrTimeStamp()
        {
            TimeSpan ts = DateTime.Now - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds);
        }

    }
}
